<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->datos)) {
    require_once("NewQRCode.php");

    $options = [
        'w' => '130',
        'h' => '130',
        'wq' => '0',
        'fc' => '#00000000'
    ];

    $generator = new \NewQRCode($data->datos, $options);
    $image = $generator->render_image();

    // Inicia un buffer de salida
    ob_start();
    imagepng($image);
    $imageData = ob_get_contents();
    ob_end_clean();

    // Libera la memoria de la imagen
    imagedestroy($image);

    // Convierte la imagen en base64
    $imageBase64 = base64_encode($imageData);

    // Devuelve la imagen en base64 en el JSON
    echo json_encode(["image64" => $imageBase64]);
} else {
    http_response_code(400);
    echo json_encode(["message" => "string vaco"]);
}
?>